﻿<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>Specyfikacja transportowa zbiorcza</title>

    <script runat="server">

        public class ParametryContext : ContextBase {
        
            public ParametryContext(Context cx) : base(cx) {
            }
            
            string kierowca;
            
            [Priority(10)]
            [Caption("Kierowca")]
            public string Kierowca {
                get { return kierowca; }
                set { kierowca = value; OnChanged(EventArgs.Empty); }
            }
            
            string nrRejestracyjny;
            
            [Priority(20)]
            [Caption("Nr rejestracyjny")]
            public string NrRejestracyjny {
                get { return nrRejestracyjny; }
                set { nrRejestracyjny = value; OnChanged(EventArgs.Empty); }
            }
        }
        
        ParametryContext parametry;
        
        [Context]
        public ParametryContext Parametry {
            get { return parametry; }
            set { parametry = value; }
        }
        
        public class TotalDH
        {
            readonly DokumentHandlowy dokument;
            Quantity masaNetto = new Quantity(0);
            Quantity masaBrutto = new Quantity(0);
            public TotalDH(DokumentHandlowy dokument)
            {
                this.dokument = dokument;
            }
            public void Add(PozycjaDokHandlowego pozycja)
            {
                if (dokument.Korekta)
                {
                    masaNetto += pozycja.MasaNetto - pozycja.PozycjaKorygowana.MasaNetto;
                    masaBrutto += pozycja.MasaNetto - pozycja.PozycjaKorygowana.MasaNetto;
                }
                else
                {
                    masaNetto += pozycja.MasaNetto;
                    masaBrutto += pozycja.MasaBrutto;
                }
            }
            public DokumentHandlowy Dokument
            {
                get { return dokument; }
            }
            public Quantity MasaNetto
            {
                get { return masaNetto; }
            }
            public Quantity MasaBrutto
            {
                get { return masaBrutto; }
            }
        }

        class NumerComparerDH : IComparer
        {
            public int Compare(object obj1, object obj2)
            {
                TotalDH t1 = (TotalDH)obj1;
                TotalDH t2 = (TotalDH)obj2;
                string s1 = t1.Dokument == null ? "" : t1.Dokument.Numer.Pelny;
                string s2 = t2.Dokument == null ? "" : t2.Dokument.Numer.Pelny;
                return s1.CompareTo(s2);
            }
        }
        
        public class TotalTwr
        {
            readonly Towar towar;
            Quantity ilość = new Quantity(0);
            Quantity masaNetto = new Quantity(0);
            Quantity masaBrutto = new Quantity(0);            
            
            public TotalTwr(Towar towar)
            {
                this.towar = towar;
            }
            public void Add(PozycjaDokHandlowego pozycja)
            {
                ilość += pozycja.Towar.PrzeliczJednostkę(pozycja.Towar.Jednostka, pozycja.ZmianaIlości, false);
                if (pozycja.Dokument.Korekta)
                {
                    masaNetto += pozycja.MasaNetto - pozycja.PozycjaKorygowana.MasaNetto;
                    masaBrutto += pozycja.MasaNetto - pozycja.PozycjaKorygowana.MasaNetto;
                }
                else
                {
                    masaNetto += pozycja.MasaNetto;
                    masaBrutto += pozycja.MasaBrutto;
                }
            }
            public Towar Towar
            {
                get { return towar; }
            }
            public Quantity Ilość
            {
                get { return ilość; }
            }
            public Quantity MasaNetto
            {
                get { return masaNetto; }
            }
            public Quantity MasaBrutto
            {
                get { return masaBrutto; }
            }

            // TID: 11775; V: 8.0; [KK];
            public Quantity MasaNettoJednostkowa {
                get {
                    if (Ilość.Value == 0) {
                            return Towar.MasaNetto;
                    }
                    Quantity q = new Quantity(MasaNetto.Value / Ilość.Value, MasaNetto.Symbol);
                    return q.Round(2);                        
                }
            }
        }
        
        class KodComparerTwr : IComparer
        {
            public int Compare(object obj1, object obj2)
            {
                TotalTwr t1 = (TotalTwr)obj1;
                TotalTwr t2 = (TotalTwr)obj2;
                string s1 = t1.Towar == null ? "" : t1.Towar.Kod;
                string s2 = t2.Towar == null ? "" : t2.Towar.Kod;
                return s1.CompareTo(s2);
            }
        }
        
        protected void dc_ContextLoad(Object sender, EventArgs e)
        {
            Row[] rowsDH = (Row[])dc[typeof(Row[])];
            
            Hashtable resultDH = new Hashtable();
            foreach (DokumentHandlowy dokument in rowsDH)
            {
                if (dokument.Anulowany) continue;
                if (dokument.Definicja.DuplikatWartosci) continue;
                if (dokument.Kontrahent == null) continue;
                TotalDH t = (TotalDH)resultDH[dokument];
                if (t == null)
                {
                    t = new TotalDH(dokument);
                    resultDH.Add(t.Dokument, t);
                }
                foreach (PozycjaDokHandlowego pozycja in dokument.Pozycje)
                {
                    t.Add(pozycja);
                }
            }
            ArrayList listaDH = new ArrayList(resultDH.Values);
            listaDH.Sort(new NumerComparerDH());
            GridDH.DataSource = listaDH;
            
            Hashtable resultTwr = new Hashtable();
            System.Collections.Generic.Dictionary<Towar, Quantity> słownikOpakowań = new System.Collections.Generic.Dictionary<Towar, Quantity>();
            foreach (DokumentHandlowy dokument in rowsDH)
            {
                if (dokument.Anulowany) continue;
                if (dokument.Definicja.DuplikatWartosci) continue;
                if (dokument.Kontrahent == null) continue;
                foreach (PozycjaDokHandlowego pozycja in dokument.Pozycje)
                {
                    TotalTwr t = (TotalTwr)resultTwr[pozycja.Towar];
                    if (t == null)
                    {
                        t = new TotalTwr(pozycja.Towar);
                        resultTwr.Add(t.Towar, t);
                    }
                    t.Add(pozycja);
                }

                 foreach( RelacjaHandlowa r in dokument.NadrzedneRelacje ) {
                    if( r.Typ == TypRelacjiHandlowej.HandlowoMagazynowa ) {
                        foreach( RelacjaHandlowa rr in r.Nadrzedny.PodrzedneRelacje ) {
                            if( rr.Typ == TypRelacjiHandlowej.Kaucji ) {
                                foreach( PozycjaDokHandlowego poz in rr.Podrzedny.Pozycje ) {
                                    if( !słownikOpakowań.ContainsKey( poz.Towar ) ) {
                                        słownikOpakowań.Add( poz.Towar, poz.ZmianaIlości );
                                    } else {
                                        słownikOpakowań[poz.Towar] += poz.ZmianaIlości;
                                    }
                                }
                            }
                        }
                    }
                }
            }

            SectionOpakowania.Visible = słownikOpakowań.Count > 0;
            GridOpakowania.DataSource = słownikOpakowań;

            ArrayList listaTwr = new ArrayList(resultTwr.Values);
            listaTwr.Sort(new KodComparerTwr());
            GridTwr.DataSource = listaTwr;

            DokumentHandlowy pierwszyDokument = null;
            foreach(DokumentHandlowy dok in rowsDH) {
                if (dok.Anulowany) continue;
                if (dok.Definicja.DuplikatWartosci) continue;
                if (dok.Kontrahent == null) continue;
                pierwszyDokument = dok;
                break;
            }

            DataLabeNrRejestracyjny.EditValue = Parametry.NrRejestracyjny;
            
            stPodpis.Caption = "<font size=2>" + pierwszyDokument.Session.Login.Operator.FullName + "</font><br><br><font size=1>..................................................<br>Podpis osoby uprawnionej do wystawienia dokumentu</font>";
            stOsoba.Caption = "<font size=2>" + pierwszyDokument.Osoba + "</font><br><br><font size=1>..................................................<br>Podpis kierowcy. Imie i nazwisko: </font>" + Parametry.Kierowca;
        }
    </script>

    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form method="post" runat="server" action="#">
        <ea:DataContext ID="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
        <eb:ReportHeader ID="ReportHeader" runat="server" Title="Specyfikacja transportowa zbiorcza" />
        <ea:Section id="SectionMagazyn" runat="server" Width="100%">
            <div style="font-weight: bold; font-size: 8pt; width: 100%; font-family: Verdana">
            Numer Rejestracyjny: <ea:DataLabel id="DataLabeNrRejestracyjny" runat="server" EncodeHTML="True" Font-Bold="True" Font-Underline="True" />
            </div> 
		</ea:Section>
        <br />
        <div style="font-weight: bold; font-size: 8pt; width: 100%; border-bottom: thin solid;
            font-family: Verdana">
            Dokumenty
        </div>
        <ea:Grid ID="GridDH" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel">
            <Columns>
                <ea:GridColumn runat="server" Width="4" Align="Right" DataMember="#" Caption="Lp.">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Align="Left" DataMember="Dokument.Numer.Pelny" Caption="Dokument~Numer"
                    Width="16">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Align="Left" DataMember="Dokument.Data" Caption="Dokument~Data"
                    Width="11">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Align="Left" DataMember="Dokument.Kontrahent.Nazwa"
                    Caption="Kontrahent~Nazwa" Width="16">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Align="Left" DataMember="Dokument.Kontrahent.Adres"
                    Caption="Kontrahent~Adres">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Align="Right" DataMember="MasaNetto" Total="Sum" Caption="Masa~Netto"
                    Width="12">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Align="Right" DataMember="MasaBrutto" Total="Sum" Caption="Masa~Brutto"
                    Width="12">
                </ea:GridColumn>
            </Columns>
        </ea:Grid>
        <br />
        <div style="font-weight: bold; font-size: 8pt; width: 100%; border-bottom: thin solid;
            font-family: Verdana">
            Towary
        </div>        
        <ea:Grid ID="GridTwr" runat="server" RowTypeName="Soneta.Towary.Towar,Soneta.Towary">
            <Columns>
                <ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp."
                    EncodeHTML="True" runat="server">
                </ea:GridColumn>
                <ea:GridColumn Width="15" DataMember="Towar.Kod" Caption="Towar~Kod"
                    EncodeHTML="True" runat="server">
                </ea:GridColumn>
                <ea:GridColumn DataMember="Towar.Nazwa" Caption="Towar~Nazwa"
                    EncodeHTML="True" runat="server">
                </ea:GridColumn>
                <ea:GridColumn Width="10" Align="Right" DataMember="Ilość"
                    Caption="Ilość" EncodeHTML="True" runat="server">
                </ea:GridColumn>
                <ea:GridColumn EncodeHTML="True" runat="server" DataMember="MasaNettoJednostkowa"
                    Align="Right" Caption="Masa jednostk." Width="14" RightBorder="None">
                </ea:GridColumn>
                <ea:GridColumn EncodeHTML="True" runat="server" Caption="/" Format="/" RightBorder="None"
                    Width="1">
                </ea:GridColumn>
                <ea:GridColumn EncodeHTML="True" runat="server" Align="Left" Caption="jm." DataMember="Towar.Jednostka"
                    Width="5">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="Masa~Netto" DataMember="MasaNetto"
                    EncodeHTML="True" Total="Sum" Align="Right" Width="12">
                </ea:GridColumn>
                <ea:GridColumn EncodeHTML="True" runat="server" Align="Right" Caption="Masa~Brutto" DataMember="MasaBrutto"
                    Total="Sum" Width="12">
                </ea:GridColumn>
            </Columns>
        </ea:Grid>
        <ea:Section ID="SectionOpakowania" runat="server">
            <br />
            <div style="font-weight: bold; font-size: 8pt; width: 100%; border-bottom: thin solid; font-family: Verdana">
                Opakowania:
            </div>        
            <ea:Grid ID="GridOpakowania" RowTypeName="System.Collections.DictionaryEntry, System.Collections" runat="server">
            <Columns>
                <ea:GridColumn DataMember="Key" Caption="Nazwa opakowania" runat="server" Width="20"></ea:GridColumn>
                <ea:GridColumn DataMember="Value" Caption="Ilość" runat="server" Width="20"></ea:GridColumn>
            </Columns>    
            </ea:Grid>
        </ea:Section>
        <br />
        <div style="font-weight: bold; font-size: 8pt; width: 100%; font-family: Verdana">
            Kwituję odbiór towaru w ilości wg powyższej specyfikacji
        </div>      
        <eb:ReportFooter ID="ReportFooter" runat="server"  Height="105px" TheEnd="false">
            <Subtitles>
			    <eb:FooterSubtitle runat="server" Caption="Operator" ID="stPodpis" SubtitleType="CenterText" Width="50"></eb:FooterSubtitle>
			    <eb:FooterSubtitle runat="server" Caption="Osoba" ID="stOsoba" SubtitleType="CenterText" Width="50"></eb:FooterSubtitle>
		    </Subtitles>
        </eb:ReportFooter>
    </form>
</body>
</html>

